/*
 * compute Fibinacci number with header file
 *
 */

#ifndef FIBINACCI
#define FIBINACCI

#include <stdio.h>
#include <stdlib.h>
 
//
// fib(0)=0
// fib(1)=1;
// fib(n) = fib(n-1)+fib(n-2)
//

#define FIBINACCI_0 0
#define FIBINACCI_1 1

long fib(int n)
{	
	long fib=FIBINACCI_0;   //fib holds the fibinacci number
	
	int i=0,  //i is used in the for loop
	    f_i_1=0,  //f_i_1 holds the value of f(i-1)
	    f_i_2=0;  //f_i_2 holds the value of f(i-2)

	//compute fibinacci number n
	if(n<0) {
		fprintf(stderr, "input n must be zero or positive\n");
		return 0;
	}

	else if(n==0) 
		return FIBINACCI_0;

	else if(n==1) 
		return FIBINACCI_1;
		
	//now, n is larger than 1
		
	//initialize f_i_1 and f_i_2
	f_i_1=FIBINACCI_1;
	f_i_2=FIBINACCI_0;
	
	//now we compute fib(i)
	for(i=2;i<=n;i++)
	{
		fib=f_i_1+f_i_2; //compute fib(i)
		f_i_2=f_i_1;     //update f_i_2, prepare for fib(i+1)
		f_i_1=fib;       //update f_i_1, prepare for fib(i+1)
	}
		
	return fib;
}   	

#endif //FIBINACCI

