#include <stdio.h>
#include <stdarg.h>


char *itoa(int, char *, int);
char *dtoa(float, char *, int); 
void myprintf(const char *, ...);

int main(void)
{	
	myprintf("this is a test: number (%d), string (%s), char (%c), float (%f) \n", 10, "hello", 'x', 3.141592);
	return 0;
}


//convert an integer to string
char *itoa(int n, char * s, int limit)
{
    snprintf(s,limit,"%d",n);
    return s;
}

//convert float to string
char *dtoa(float f, char *s, int limit)
{
    snprintf(s,limit,"%f",f);
    return s;
}

void myprintf(const char *fmt, ...)
{
	const char *p; //pointer to char
	int i;
	float f;
	char *s;
	char fmtbuf[256];
	
	va_list argp; //used for va macros
	
	//macro: va_start(va_list, last fixed param)
	va_start(argp, fmt); //Requires the last fixed parameter (to get the address)
	



	for(p = fmt; *p != '\0'; p++)
	{
		if(*p != '%')
		{
			putchar(*p);
			continue;
		}
	
		switch(*++p)
		{
			case 'c':
			
			    //macro: va_arg(va_list, cast type), 
			    //va_arg: Requires the type to cast to. Increments ap to the next argument.
				i = va_arg(argp, int); 
				putchar(i);
				break;
	
			case 'd':
				i = va_arg(argp, int);
				s = itoa(i, fmtbuf, 10);
				fputs(s, stdout);
				break;
	
			case 's':
				s = va_arg(argp, char *);
				fputs(s, stdout);
				break;
	
			case 'f':
				f = va_arg(argp, double);
				s = dtoa(f, fmtbuf, 16);
				fputs(s, stdout);
				break;
	
			case '%':
				putchar('%');
				break;
		}//end switch
	}
	
	//maco: va_end(va_list)
	va_end(argp);
}



