#include <malloc.h>
#include "bad_malloc.h"

int oom;

static void *(*malloc_hook)(size_t, const void *);
static void *(*realloc_hook)(void *, size_t, const void *);
static void (*free_hook)(void *, const void *);

static void restore_hooks(void);
static void set_hooks(void);

static void *bmalloc(size_t size, const void *caller)
{
	if (oom)
		return 0;
	restore_hooks();
	void *ret = malloc(size);
	set_hooks();
	return ret;
}

static void *brealloc(void *p, size_t size, const void *caller)
{
	if (oom)
		return 0;
	restore_hooks();
	void *ret = realloc(p, size);
	set_hooks();
	return ret;
}

static void bfree(void *p, const void *caller)
{
	restore_hooks();
	free(p);
	set_hooks();
}

static void binit(void)
{
	malloc_hook = __malloc_hook;
	realloc_hook = __realloc_hook;
	free_hook = __free_hook;
	set_hooks();
}

void restore_hooks(void)
{
	__malloc_hook = malloc_hook;
	__realloc_hook = realloc_hook;
	__free_hook = free_hook;
}

void set_hooks(void)
{
	__malloc_hook = bmalloc;
	__realloc_hook = brealloc;
	__free_hook = bfree;
}

void (*volatile __malloc_initialize_hook)(void) = binit;
