#include <assert.h>
#include <stdio.h>
#include "bn.h"

typedef struct
{
	unsigned long ebp;
	unsigned long ebx;
	unsigned long esi;
	unsigned long edi;
} regs;

extern void *test_fun(regs *before,	// ebp + 8
		      regs *after,	// ebp + 12
		      void *fun,		// ebp + 16
		      int nargs,		// ebp + 20
		      ...);			// ebp + 24

static int fail;
static void compare_regs(const char *fun, const regs *before, const regs *after)
{
#define X(r) \
	do { if (before-> r != after-> r) \
	{ \
		++fail; \
		printf("%s: " #r " not preserved: %lx, %lx\n", \
		       fun, before-> r, after-> r); \
	} } while (0)
	X(ebp);
	X(ebx);
	X(esi);
	X(edi);
#undef X
}

#define TEST(rtype, fun, nargs, proto, ...) \
static rtype test_ ## fun proto \
{ \
	regs before, after; \
	rtype ret = (rtype)test_fun(&before, &after, fun, nargs, ## __VA_ARGS__); \
	compare_regs(#fun, &before, &after); \
	return ret; \
}
TEST(bn*, bn_new, 0, (void));
TEST(int, bn_free, 1, (bn *x), x);
TEST(int, bn_hex2bn, 2, (bn *x, const char *hex), x, hex);
TEST(int, bn_bn2hex, 3, (char *hex, size_t size, const bn *x), hex, size, x);
TEST(int, bn_add, 3, (bn *r, const bn *x, const bn *y), r, x, y);
#undef TEST

#define bn_new test_bn_new
#define bn_free test_bn_free
#define bn_hex2bn test_bn_hex2bn
#define bn_bn2hex test_bn_bn2hex
#define bn_add test_bn_add

int main(void)
{
	bn *x = bn_new();
	bn *y = bn_new();
	bn *z = bn_new();
	assert(x);
	assert(y);
	assert(z);

	int ret = bn_hex2bn(x, "Feed");
	assert(!ret);
	ret = bn_hex2bn(y, "CafeF00d5");
	assert(!ret);
	ret = bn_add(x, x, x);
	assert(!ret);
	ret = bn_add(y, y, x);
	assert(!ret);
	ret = bn_hex2bn(x, "123456789abcdef");
	assert(!ret);
	ret = bn_add(z, x, y);
	assert(!ret);

	char x_str[20];
	char y_str[20];
	char z_str[20];
	ret = bn_bn2hex(x_str, sizeof x_str, x);
	assert(!ret);
	ret = bn_bn2hex(y_str, sizeof y_str, y);
	assert(!ret);
	ret = bn_bn2hex(z_str, sizeof z_str, z);
	assert(!ret);
	bn_free(x);
	bn_free(y);
	bn_free(z);
	printf("x: %s\ny: %s\nz: %s\n", x_str, y_str, z_str);
	return 0;
}
