#include <stdio.h>
#include <math.h>
#include "test.h"

typedef struct
{
	unsigned long ebp;
	unsigned long ebx;
	unsigned long esi;
	unsigned long edi;
} regs;

extern void *test_fun(regs *before,	// ebp + 8
		      regs *after,	// ebp + 12
		      void *fun,	// ebp + 16
		      int nargs,	// ebp + 20
		      ...);		// ebp + 24

int aborted;
int total_tests;
int failed_tests;
int check_regs;

static void compare_regs(const char *fun, const regs *before, const regs *after)
{
	int match = 0;
	++total_tests;
	if (!aborted)
	{
#define X(r) \
	do { \
		if (before-> r != after-> r) \
		{ \
			match = 0; \
			fprintf(stderr, "%s: " #r " not preserved: %lx, %lx\n", \
			       fun, before-> r, after-> r); \
		} \
	} while (0)
		match = 1;
		X(ebp);
		X(ebx);
		X(esi);
		X(edi);
#undef X
	}
	if (!match)
		++failed_tests;
}

#undef bn_new
#undef bn_free
#undef bn_hex2bn
#undef bn_bn2hex
#undef bn_add

#define X(rtype, fun, nargs, proto, ...) \
rtype test_ ## fun proto \
{ \
	rtype ret = 0; \
	regs before, after; \
	if (!aborted) \
	{ \
		ret = (rtype)test_fun(&before, &after, fun, nargs, ## __VA_ARGS__); \
	} \
	if (check_regs) \
		compare_regs(#fun, &before, &after); \
	return ret; \
}
X(bn*, bn_new, 0, (void));
X(int, bn_free, 1, (bn *x), x);
X(int, bn_hex2bn, 2, (bn *x, const char *hex), x, hex);
X(int, bn_bn2hex, 3, (char *hex, size_t size, const bn *x), hex, size, x);
X(int, bn_add, 3, (bn *r, const bn *x, const bn *y), r, x, y);
#undef X

void print_test_results(int total_points)
{
	int passed_tests = total_tests - failed_tests;
	int points = rint((float)passed_tests/total_tests*total_points);
	if (failed_tests && points == total_points)
		--points;
	printf("%d/%d %d/%d\n", passed_tests, total_tests, points, total_points);
}
