#ifndef TEST_H
#define TEST_H

#include <stdlib.h>

#include "bn.h"

extern int total_tests;
extern int failed_tests;
extern int aborted;

extern int check_regs;

extern bn *test_bn_new(void);
extern int test_bn_free(bn *);
extern int test_bn_hex2bn(bn *, const char *);
extern int test_bn_bn2hex(char *, size_t, const bn *);
extern int test_bn_add(bn *, const bn *, const bn *);

extern void print_test_results(int total_points);

#define bn_new test_bn_new
#define bn_free test_bn_free
#define bn_hex2bn test_bn_hex2bn
#define bn_bn2hex test_bn_bn2hex
#define bn_add test_bn_add

#define TEST(cond, reason) \
	do { \
		++total_tests; \
		if (aborted) \
			++failed_tests; \
		else if (!(cond)) \
		{ \
			++failed_tests;\
			fputs(reason "\n", stderr); \
		} \
	} while (0)

#define REQUIRE(cond, reason) \
	do { \
		if (!aborted && !(cond)) \
		{ \
			fputs("test aborted: " reason "\n", stderr); \
			aborted = 1; \
		} \
	} while (0)
#endif
