#include <assert.h>
#include <stdio.h>
#include <string.h>
#include "bn.h"
#include "test.h"

struct
{
	const char *hex;
	int nlimbs;
	uint32_t limbs[4];
} small_num[] =
{
	{
		.hex = "0",
		.nlimbs = 1,
		.limbs = { 0 },
	},
	{
		.hex = "1",
		.nlimbs = 1,
		.limbs = { 1 },
	},
	{
		.hex = "ab",
		.nlimbs = 1,
		.limbs = { 0xab },
	},
	{
		.hex = "abc",
		.nlimbs = 1,
		.limbs = { 0xabc },
	},
	{
		.hex = "abcd",
		.nlimbs = 1,
		.limbs = { 0xabcd },
	},
	{
		.hex = "12345678",
		.nlimbs = 1,
		.limbs = { 0x12345678 },
	},
	{
		.hex = "1234567890",
		.nlimbs = 2,
		.limbs = { 0x34567890, 0x12 },
	},
	{
		.hex = "aaaabbbbccccddddeeeeffff",
		.nlimbs = 3,
		.limbs = { 0xeeeeffff, 0xccccdddd, 0xaaaabbbb },
	},
	{
		.hex = "12345678876543211234567887654321",
		.nlimbs = 4,
		.limbs = { 0x87654321, 0x12345678, 0x87654321, 0x12345678 },
	},
	{
		.hex = "a000000001111111122222222",
		.nlimbs = 4,
		.limbs = { 0x22222222, 0x11111111, 0x00000000, 0xa },
	},
	{
		.hex = 0,
		.nlimbs = 0,
		.limbs = { 0 },
	}
};

int main(void)
{
	int do_reg_check = 1;
	bn x;
	for (int i = 0; small_num[i].hex; ++i)
	{
		x.size = small_num[i].nlimbs;
		x.nlimbs = small_num[i].nlimbs;
		x.d = small_num[i].limbs;

		size_t size = strlen(small_num[i].hex);
		char buffer[size+1];

		check_regs = do_reg_check;
		TEST(-1 == bn_bn2hex(buffer, size, &x),
		     "bn_bn2hex did not fail!");
		TEST(!bn_bn2hex(buffer, size+1, &x),
		     "bn_bn2hex did not succeed");
		TEST(!strcmp(small_num[i].hex, buffer),
		     "incorrect string");
		do_reg_check = check_regs = 0;
	}

	print_test_results(8);
	return failed_tests;
}
