#include <assert.h>
#include <stdio.h>
#include <string.h>
#include "bn.h"
#include "test.h"

const char *const small_num[] =
{
	"0",
	"1",
	"ab",
	"abc",
	"AbCd",
	"12345678",
	"1234567890",
	"aaaaBBBBccccDDDDeeeeFFFF",
	"12345678876543211234567887654321",
	"a000000001111111122222222",
	0,
};

const char *const sum[] = 
{
	"0",
	"0",
	"1",
	"2",
	"ad",
	"158",
	"c14",
	"16d0",
	"c29d",
	"16e6a",
	"1235c4e2",
	"246a1b5a",
	"1258c093ea",
	"248d170c7a",
	"aaaabbbbccccde027c060c79",
	"1555577779999bbe06af50c78",
	"12345679dcbaba98abce1258f25a4f99",
	"2468acf2641ffdb9be0268d179bf92ba",
	"2468acfc641ffdb9cf1379e29be1b4dc",
	"2468ad06641ffdb9e0248af3be03d6fe",
	"48d15a0cc83ffb73c04915e77c07adfc",
};

static void compare(bn *result, const char *expected)
{
	size_t size = strlen(expected);
	char buf[2*size + 10]; // make it extra big, just in case
	REQUIRE(!bn_bn2hex(buf, sizeof buf, result), "bn_bn2hex failed");
	int eq = !strcmp(buf, expected);
	TEST(eq, "not equal");
	if (!eq)
		REQUIRE(!bn_hex2bn(result, expected), "bn_hex2bn failed");
}

int main(void)
{
	int do_reg_check = 1;
	bn *accum = bn_new();
	REQUIRE(accum, "bn_new returned NULL");
	REQUIRE(!bn_hex2bn(accum, "0"), "bn_hex2bn failed");

	bn *x = bn_new();
	REQUIRE(x, "bn_new returned NULL");

	int i;
	for (i = 0; small_num[i]; ++i)
	{
		REQUIRE(!bn_hex2bn(x, small_num[i]), "bn_hex2bn failed");
		check_regs = do_reg_check;
		TEST(!bn_add(accum, accum, x), "bn_add(accum, accum, x) failed");
		compare(accum, sum[2*i]);
		TEST(!bn_add(accum, x, accum), "bn_add(accum, x, accum) failed");
		compare(accum, sum[2*i+1]);
		do_reg_check = 0;
	}
	do_reg_check = 1;
	TEST(!bn_add(accum, accum, accum), "bn_add(accum, accum, accum) failed");
	compare(accum, sum[2*i]);
	bn_free(accum);
	bn_free(x);
	print_test_results(8);
	return failed_tests;
}
