#include <assert.h>
#include <stdio.h>
#include <string.h>
#include "bn.h"
#include "test.h"
#include "bad_malloc.h"

int main(void)
{
	bn *x = bn_new();
	REQUIRE(x, "x = bn_new() returned NULL");

	oom = 1;
	int ret = bn_hex2bn(x, "abc");
	oom = 0;

	TEST(ret == -1, "bn_hex2bn didn't fail");

	REQUIRE(!bn_hex2bn(x, "abc"), "bn_hex2bn failed");
	oom = 1;
	ret = bn_hex2bn(x, "12345678");
	oom = 0;
	TEST(!ret, "bn_hex2bn failed");

	int old_size = x->size;
	int nlimbs = x->size + 1;
	char *buf = malloc(nlimbs * 8 + 1);
	memset(buf, 'C', nlimbs * 8);
	buf[nlimbs * 8] = 0;
	oom = 1;
	ret = bn_hex2bn(x, buf);
	oom = 0;
	TEST(ret == -1, "bn_hex2bn didn't fail to resize");
	TEST(x->size == old_size, "size changed");
	TEST(x->nlimbs == 1, "nlimbs changed");
	TEST(x->d[0] == 0x12345678, "limbs changed");
	bn_free(x);
	free(buf);

	print_test_results(2);
	return failed_tests;
}
