#include <assert.h>
#include <stdio.h>
#include <string.h>
#include "bad_malloc.h"
#include "bn.h"
#include "test.h"

int main(void)
{
	bn *x = bn_new();
	REQUIRE(x, "x = bn_new() returned NULL");
	bn *y = bn_new();
	REQUIRE(y, "y = bn_new() returned NULL");
	bn *z = bn_new();
	REQUIRE(z, "z = bn_new() returned NULL");

	REQUIRE(!bn_hex2bn(x, "0"), "bn_hex2bn failed");
	REQUIRE(!bn_hex2bn(y, "1"), "bn_hex2bn failed");
	
	uint32_t size = x->size;
	uint32_t nlimbs = x->nlimbs;
	REQUIRE(nlimbs >= 1, "nlimbs too small");
	uint32_t limb = x->d[0];
	char buf[8*(size + 1) + 1];
	memset(buf, 'b', sizeof buf - 1);
	buf[sizeof buf - 1] = 0;
	REQUIRE(!bn_hex2bn(z, buf), "bn_hex2bn failed");

	oom = 1;
	int ret = bn_add(x, y, z);
	oom = 0;
	TEST(ret == -1, "bn_add should have failed");
	TEST(size == x->size, "size changed");
	TEST(nlimbs == x->nlimbs, "nlimbs changed");
	TEST(limb == x->d[0], "first limb changed");

	print_test_results(2);
	return failed_tests;
}
