	.file	"test.s"
	.local	.Lsaved_ebp
	.comm	.Lsaved_ebp,4,4
	.text
	.globl	test_fun
	.type	test_fun, @function
test_fun:
	pushl	%ebp
	movl	%esp, %ebp
	# Reserve space for ebx, esi, edi, and args.
	# |seip| <--  4
	# |sebp| <--  8
	# |sebx| <-- 12
	# |sesi| <--  0
	# |sedi| <--  4
	# To keep 16-byte alignment, we need to reserve
	# 12 + (nargs + 3)/4 * 16 bytes
	# = (nargs + 6)/4 * 16 bytes
	movl	20(%ebp), %ecx
	leal	6(%ecx), %eax
	shrl	$2, %eax
	shll	$4, %eax
	subl	%eax, %esp

	# save esi and edi
	movl	%ebx, -4(%ebp)
	movl	%esi, -8(%ebp)
	movl	%edi, -12(%ebp)

	# Copy arguments to bottom of stack
	testl	%ecx, %ecx
	jz	.Lnocopy
	movl	%esp, %edi
	leal	24(%ebp), %esi
	rep movsl
.Lnocopy:

	# Save old regs
	movl	8(%ebp), %eax
	movl	%ebp,  0(%eax)
	movl	%ebx,  4(%eax)
	movl	%esi,  8(%eax)
	movl	%edi, 12(%eax)

	# Call the function but save ebp globally in case it gets messed up.
	movl	%ebp, .Lsaved_ebp
	movl	16(%ebp), %eax
	call	*%eax

	# Save new regs
	movl	.Lsaved_ebp, %ecx
	movl	12(%ecx), %edx
	movl	%ebp,  0(%edx)
	movl	%ebx,  4(%edx)
	movl	%esi,  8(%edx)
	movl	%edi, 12(%edx)

	# Restore ebp, esi, edi
	movl	%ecx, %ebp
	movl	-12(%ebp), %edi
	movl	-8(%ebp), %esi
	movl	-4(%ebp), %ebx

	leave
	ret
	.size	test_fun, .-test_fun
