/**********************************************************************************/

/*
 * File: slist.c
 * Author: ECE 275 Spring 2016
 * Date: Feb 09, 2016
 *
 * Description: Singly-linked list of integers
 *
 */

/**********************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include "slist.h"

/**********************************************************************************/

void SListAppend(SList* list, SListNode* newNode) {
   if (list == NULL ) return;
   
   if (list->head == NULL) { // List empty
      list->head = newNode;
      list->tail = newNode;
   }
   else{
      list->tail->next = newNode;
      list->tail = newNode;
   }
   list->size++;   // Increase size
}

/**********************************************************************************/

void SListPrepend(SList* list, SListNode* newNode) {
   if (list == NULL ) return;
   
   if (list->head == NULL) { // List empty
      list->head = newNode;
      list->tail = newNode;
   }
   else {
      newNode->next = list->head;
      list->head = newNode;
   }
   
   list->size++;    // Increase size
}

/**********************************************************************************/

void SListInsertAfter(SList* list, SListNode* curNode, SListNode* newNode) {
   if (list == NULL ) return;
   
   if (list->head == NULL) { // List empty
      list->head = newNode;
      list->tail = newNode;
   }
   else if (curNode == list->tail) { // Insert after tail
      list->tail->next = newNode;
      list->tail = newNode;
   }
   else {
      newNode->next = curNode->next;
      curNode->next = newNode;
   }
   
   list->size++;    // Increase size
}

/**********************************************************************************/

void SListPrint(SList* list) {
   SListNode* curNode = NULL;
   
   if (list == NULL) return;
   
   curNode = list->head;
   while (curNode != NULL) {
      printf("%d ", curNode->data);
      curNode = curNode->next;
   }
   
   printf("\n");
}

/**********************************************************************************/

SListNode* SListSearch(SList* list, int key) {
   SListNode* curNode = NULL;
   
   if (list == NULL) return NULL;
   
   curNode = list->head;
   while (curNode != NULL) {
      if (curNode->data == key) {
         return curNode;
      }
      curNode = curNode->next;
   }
   
   return NULL;
}

/**********************************************************************************/

// FIXME: The SListRemoveAfter should deallocate the node being
// removed. Modify the following code to keep track of the node
// being removed, and free that node before the function returns.

void SListRemoveAfter(SList* list, SListNode* curNode) {
   SListNode* sucNode = NULL;
   
   if (list == NULL) return;
   
   // Special case, remove head
   if (curNode == NULL && list->head != 0) {
      sucNode = list->head->next;
      list->head = sucNode;
      
      if (sucNode == NULL) { // Removed last item
         list->tail = NULL;
      }
   }
   else if (curNode->next != NULL) {
      sucNode = curNode->next->next;
      curNode->next = sucNode;
      
      if (sucNode == 0) { // Removed tail
         list->tail = curNode;
      }
   }
}

/**********************************************************************************/
