/**********************************************************************************/

/*
 * File: slist.h
 * Author: ECE 275 Spring 2016
 * Date: Feb 09, 2016
 *
 * Description: Singly-linked list of integers
 *
 */

/**********************************************************************************/

#ifndef SLIST_H
#define SLIST_H

/**********************************************************************************/

typedef struct SListNode_struct {
   int data;
   struct SListNode_struct *next;
} SListNode;

typedef struct SList_struct {
   SListNode *head;
   SListNode *tail;
   int size;
} SList;

/**********************************************************************************/

void SListAppend(SList* list, SListNode* newNode);

void SListPrepend(SList* list, SListNode* newNode);

void SListInsertAfter(SList* list, SListNode* currNode, SListNode* newNode);

void SListPrint(SList* list);

SListNode* SListSearch(SList* list, int key);

void SListRemoveAfter(SList* list, SListNode* currNode);

/**********************************************************************************/

#endif

/**********************************************************************************/
