//------------------------------------------------------------------------------------------------

//
// File: main.cpp
// Author: ECE 275 Spring 2016
// Date: March 03, 2016
//
// Description:
//

//------------------------------------------------------------------------------------------------

#include <iostream>
#include "timeddist.h"
#include "racetimes.h"

//------------------------------------------------------------------------------------------------

using namespace std;

//------------------------------------------------------------------------------------------------

int main(int argc, char *argv[]) {
   float avgSpeedMPH = 0.0;
   float totalDistMile = 0.0;
   float totalTimeSec = 0.0;
   RaceTimes raceTimes(3);
   int i;
   //------------------------------------------------------------------------------------------------
   // Poll 1: Example code illustrating .at() versus []
   //------------------------------------------------------------------------------------------------
//   vector<int> myScores(3);
//   for (i = 0; i<myScores.size(); ++i) {
//      myScores.at(i) = i;
//   }
//   
//   cout << myScores[4] << " ";
//   cout << myScores.at(4);
//   cout << endl;
   //------------------------------------------------------------------------------------------------
   
   //------------------------------------------------------------------------------------------------
   // Poll 2: Example code for extracting characters
   //------------------------------------------------------------------------------------------------
//   int scoreA = 5;
//   int scoreB = 0;
//   
//   cin >> scoreA >> scoreB;
//   cout << scoreA << ", " << scoreB;
//   cout << endl;
   //------------------------------------------------------------------------------------------------

   // 1. read race times from user
   if (argc == 1) {
	   raceTimes.ReadUserTimes();
   }
   else if (argc == 2) {
	   raceTimes.ReadUserTimesFromFile(argv[1]);
   }
   else {
      cout << "Usage: racetimes inFile" << endl;
      return -1;
   }

   // 2. Make calculations on existing raceTimes  array
   avgSpeedMPH = raceTimes.GetAvgSpeedMPH();
   totalDistMile = raceTimes.GetTotalDistMiles();
   totalTimeSec = raceTimes.GetTotalTimeSec();

   // 3. Display output
   raceTimes.Print();
   
   cout << "Total Distance = " << totalDistMile << " miles" << endl;
   cout << "Total Time = " << totalTimeSec << " seconds " << endl;
   cout << "Average Speed = " << avgSpeedMPH << " miles per hour" << endl;
   
   return 0;
}

//------------------------------------------------------------------------------------------------
