//------------------------------------------------------------------------------------------------

//
// File: racetimes.cpp
// Author: ECE 275 Spring 2016
// Date: March 03, 2016
//
// Description:
//

//------------------------------------------------------------------------------------------------

#include <iostream>
#include <vector>
#include <fstream>
#include <string>
#include <sstream>
#include <climits>
#include "racetimes.h"
#include "timeddist.h"

//------------------------------------------------------------------------------------------------

using namespace std;

//------------------------------------------------------------------------------------------------

// Default constructor

RaceTimes::RaceTimes() : times(3) {
   // Nothing to see here
}

//------------------------------------------------------------------------------------------------

RaceTimes::RaceTimes(int numTimes) : times(numTimes) {
   // Nothing to see here
}

//------------------------------------------------------------------------------------------------

void RaceTimes::SetNumTimes(int numTimes) {
   times.resize(numTimes);
}

//------------------------------------------------------------------------------------------------

int RaceTimes::GetNumTimes() {
   return times.size();
}

//------------------------------------------------------------------------------------------------

// Calculates the speed in MPH, averaged over the total time and distance traveled.
// The algorithm is: avgMpg = distance / time

float RaceTimes::GetAvgSpeedMPH() {
   float totaldist = 0, totaltime = 0;
   float avgSpeed = 0;
   int i = 0;
   
   for (i = 0; i < times.size(); i++) {
      totaldist = totaldist + times.at(i).GetDistanceMiles();
      totaltime = totaltime + times.at(i).GetTimeSeconds() / 3600.0;
   }
   
   avgSpeed = totaldist / totaltime;
   return avgSpeed;
}

//------------------------------------------------------------------------------------------------

// Calculate the total distance traveled in miles
// The algorithm is
//   Loop over all the times
//     Update the total miles traveled
//   Return that value at the end.

float RaceTimes::GetTotalDistMiles() {
   int i = 0;
   float sum_total = 0.0;
   
   for (i = 0; i < times.size(); i++) {
      sum_total += times.at(i).GetDistanceMiles();
   }
   
   return sum_total;
}

//------------------------------------------------------------------------------------------------

// Look at the times passed in, and calculate the number of seconds that have elapsed.
// The algorithm is:
//    Loop over all the times
//       Take the time in each slot (in minutes) and convert it to seconds
//       Update the total seconds
//    Return that value at the end.

float RaceTimes::GetTotalTimeSec() {
   int i;
   TimedDist totalTime;
   
   for (i = 0; i < times.size(); ++i) {
      totalTime = totalTime + times.at(i);
   }
   
   return totalTime.GetTimeSeconds();
}

//------------------------------------------------------------------------------------------------

// Read race times from user using standard IO. Allows the user to enter an optional note
// at the end of the line.

void RaceTimes::ReadUserTimes() {
   int i = 0;
   char colon;
   float seconds = 0.0;
   float miles = 0.0;
   int minutes = 0;
   string note;
   string inputLine;
   
   i = 0;
   while (i < times.size() ) {
      
      cout << "Enter timed distance (MMM:SS.SS MILES NOTE): ";
      getline(cin, inputLine);
      
      istringstream lineStream(inputLine);
      lineStream >> minutes >> colon >> seconds >> miles;
      
      if (lineStream.fail() || colon != ':') {
         cout << "Invalid format." << endl;
         cout << "Enter timed distance (MMM:SS.SS MILES NOTE): ";
      }
      
      // Attempt to read the rest of the line as the note.
      getline(lineStream, note);
      
      // Remove any leading spaces
      while (note.length() > 0 && note.at(0) == ' ') {
         note.erase(note.begin());
      }
      
      // If the note is empty, then we should not pass a
      // note to the TimedDist constructor
      if (note.length() == 0) {
         times.at(i) = TimedDist(minutes, seconds, miles);
         i++;
      }
      else {
         // Pass the note to the TimedDist constructor.
         // Note that c_str() returns a pointer to the C
         // string (i.e., char *) for a string variable.
         times.at(i) = TimedDist(minutes, seconds,
                                 miles, note.c_str());
         i++;
      }
   }
}

//------------------------------------------------------------------------------------------------

// Read race times from file. This function does not support reading in a note from the file.

bool RaceTimes::ReadUserTimesFromFile(char* inputFileName) {
   int i = 0;
   char colon;
   float seconds = 0.0;
   float miles = 0.0;
   int minutes = 0;
   string note;
   string inputLine;
   ifstream inFile;
   
   // The open() function for file streams requires a C string (i.e., a char *). The
   // c_str() function returns a char * for a string variable.
   inFile.open(inputFileName);
   
   if (!inFile.good()) {
      cout << "Could not open file " << inputFileName << endl;
      return false;
   }
      
   i = 0;
   while (inFile.good() && i < times.size() ) {
      getline(inFile, inputLine);
      if (inFile.fail()) break; // Note: What if we tried to use .good()?

      istringstream lineStream(inputLine);
      lineStream >> minutes >> colon >> seconds >> miles;
      
      if (lineStream.fail() || colon != ':') {
         // Invalid format, silently skipping line
         continue;
      }
      
      // Attempt to read the rest of the line as the note.
      getline(lineStream, note);
      
      // Remove any leading spaces
      while (note.length() > 0 && note.at(0) == ' ') {
         note.erase(note.begin());
      }
      
      // If the note is empty, then we should not pass a
      // note to the TimedDist constructor
      if (note.length() == 0) {
         times.at(i) = TimedDist(minutes, seconds, miles);
         i++;
      }
      else {
         // Pass the note to the TimedDist constructor.
         // Note that c_str() returns a pointer to the C
         // string (i.e., char *) for a string variable.
         times.at(i) = TimedDist(minutes, seconds,
                                 miles, note.c_str());
         i++;
      }
   }
   
   inFile.close();
   return true;
}

//------------------------------------------------------------------------------------------------

// Prints all timed distance for race

void RaceTimes::Print()
{
   unsigned int i = 0;
   
   cout << endl;
   for (i = 0; i < times.size(); ++i) {
      times.at(i).Print();
   }
}

//------------------------------------------------------------------------------------------------


