//------------------------------------------------------------------------------------------------

//
// File: timeddist.cpp
// Author: ECE 275 Spring 2016
// Date: March 03, 2016
//
// Description:
//

//------------------------------------------------------------------------------------------------

// Uncomment the following to see dbuging messages for the constructor, assignment operator
// and destructor

// #define DEBUG

//------------------------------------------------------------------------------------------------

#include <iostream>
#include <cstring>
#include "timeddist.h"

//------------------------------------------------------------------------------------------------

using namespace std;

//------------------------------------------------------------------------------------------------

// Constants used for converting times and distance

const int SecondsPerMinute = 60;
const float KmPerMile = 1.60934;

//------------------------------------------------------------------------------------------------
//
// Default constructor Initializes all member variables to 0
//
//------------------------------------------------------------------------------------------------

TimedDist::TimedDist() {
   minutes = 0;
   seconds = 0.0;
   miles = 0.0;
   note = 0; // there is no note, initialize to null (i.e., 0)

#ifdef DEBUG
   cout << "Default Constructor Called" << endl;
#endif
}

//------------------------------------------------------------------------------------------------
//
// Constructor that allows member variable to be initialzed. This constructor  can take three or
// four arguments, where the last argument is optional.
//
//------------------------------------------------------------------------------------------------

TimedDist::TimedDist(int minutes, float seconds, float miles, const char *note) {
   this->minutes = minutes;
   this->seconds = seconds;
   this->miles = miles;
   
   if (note == 0) {
      this->note = 0;
   }
   else {
      // Allocate an array for the C string and copy the string
      this->note = new char[strlen(note)+1];
      strcpy(this->note, note);
   }
   
#ifdef DEBUG
   cout << "Custom Constructor Called" << endl;
#endif
}

//------------------------------------------------------------------------------------------------
//
// + opertor will add the times and
//
//------------------------------------------------------------------------------------------------

TimedDist TimedDist::operator+(TimedDist rhs) {
   TimedDist timeDistTotal;
   
   timeDistTotal.miles = miles + rhs.miles;
   timeDistTotal.minutes = minutes + rhs.minutes;
   timeDistTotal.seconds = seconds + rhs.seconds;
   
   if (timeDistTotal.seconds > 60) {
      timeDistTotal.minutes++;
      timeDistTotal.seconds -= 60;
   }
   
   return timeDistTotal;
}


//------------------------------------------------------------------------------------------------
//
// Copy constructor
//
//------------------------------------------------------------------------------------------------

TimedDist::TimedDist(const TimedDist& rhs) {
   minutes = rhs.minutes;
   seconds = rhs.seconds;
   miles = rhs.miles;
   
   if (rhs.note == 0 ) {
      note = 0;
   }
   else {
      // Allocate an array for the C string and copy the string
      note = new char[strlen(rhs.note)+1];
      strcpy(note, rhs.note);
   }
   
#ifdef DEBUG
   cout << "Copy Constructor Called" << endl;
#endif
}

//------------------------------------------------------------------------------------------------
//
// Copy constructor
//
//------------------------------------------------------------------------------------------------

TimedDist& TimedDist::operator=(const TimedDist& rhs) {
   minutes = rhs.minutes;
   seconds = rhs.seconds;
   miles = rhs.miles;
   
   if (rhs.note == 0 ) {
      note = 0;
   }
   else {
      // Allocate an array for the C string and copy the string
      note = new char[strlen(rhs.note)+1];
      strcpy(note, rhs.note);
   }
   
#ifdef DEBUG
   cout << "Copy Assignment Operator Called" << endl;
#endif
   
   return *this;
}

//------------------------------------------------------------------------------------------------
//
// Destructor: deallocates (i.e., deletes) the memory for the note if it existsed.
//
//------------------------------------------------------------------------------------------------

TimedDist::~TimedDist() {
   
   // Check that the note exists (i.e., note is not null)
   if( note != 0 ) {
      
      // Delete the note. Because the note is allocated as an array, we must use "delete []"
      // BUT, we can't do this yet, because we have not implemented a deep copy.
      delete [] note;
      note = 0;
   }
   
#ifdef DEBUG
   cout << "Destructor Called" << endl;
#endif
}

//------------------------------------------------------------------------------------------------
//
// Member function to set the time
//
//------------------------------------------------------------------------------------------------

void TimedDist::SetTime(int minutes, float seconds) {
   this->minutes = minutes;
   this->seconds = seconds;
}

//------------------------------------------------------------------------------------------------
//
// Member function to set the distance
//
//------------------------------------------------------------------------------------------------

void TimedDist::SetDistance(float miles) {
   this->miles =  miles;
}

//------------------------------------------------------------------------------------------------
//
// Member function to get the time in minutes
//
//------------------------------------------------------------------------------------------------

float TimedDist::GetTimeMinutes() {
   return static_cast<float>(minutes) + seconds / static_cast<float>(SecondsPerMinute);
}

//------------------------------------------------------------------------------------------------
//
// Member function to get the time in seconds
//
//------------------------------------------------------------------------------------------------

float TimedDist::GetTimeSeconds() {
   return seconds + static_cast<float>(minutes) * static_cast<float>(SecondsPerMinute);
}

//------------------------------------------------------------------------------------------------
//
// Member function to get the distance in miles
//
//------------------------------------------------------------------------------------------------

float TimedDist::GetDistanceMiles() {
   return miles;
}

//------------------------------------------------------------------------------------------------
//
// Member function to get the distance in miles
//
//------------------------------------------------------------------------------------------------

float TimedDist::GetDistanceKm() {
   return miles * KmPerMile;
}

//------------------------------------------------------------------------------------------------
//
// Prints the timed distance
//
//------------------------------------------------------------------------------------------------

void TimedDist::Print() {
   cout << "Time: " << minutes << ":" << seconds << " Dist: " << miles << " miles";
   
   // If optional note exits, print it.
   if (note != 0) {
      cout << endl << "  Note: " << note;
   }
   cout << endl;
}

//------------------------------------------------------------------------------------------------

