//------------------------------------------------------------------------------------------------

//
// File: timeddist.h
// Author: ECE 275 Spring 2016
// Date: March 03, 2016
//
// Description:
//

//------------------------------------------------------------------------------------------------

#ifndef TIMEDDIST_H
#define TIMEDDIST_H

//------------------------------------------------------------------------------------------------

#include <string>

using namespace std;

//------------------------------------------------------------------------------------------------

class TimedDist {
private:
   int minutes;
   float seconds;
   float miles;
   char *note; // Used to store an optional note
   
public:
   TimedDist();  // Default Constructor
   
   // Constructor that can take three or four arguments. As the note is
   // optional, a default parameter value of 0 for the note input is specified.
   // Note that the note parameter is defined as a const char * as the constructor
   // should not make changes to the input C string.
   TimedDist(int minutes, float seconds, float miles, const char *note = 0);
   TimedDist(const TimedDist& origClass);
   TimedDist& operator=(const TimedDist& rhs);

   // Overload the + operator
   TimedDist operator+(TimedDist rhs);

   // Destructor
   ~TimedDist();
   
   // Member functions to set the time and distance
   void SetTime(int minutes, float seconds);
   void SetDistance(float miles);
   
   // Member functios to get the time and distance without options
   // for different units for each
   float GetTimeMinutes();
   float GetTimeSeconds();
   float GetDistanceMiles();
   float GetDistanceKm();
   
   void Print(); // Print the timed distance
};


//------------------------------------------------------------------------------------------------

#endif

//------------------------------------------------------------------------------------------------
