#lang racket

(define (count-down n)
  (cond
    [(equal? n 0) empty] ; base case
    [else
      (cons
        n
        (count-down (- n 1)))])) ; n must get smaller, so if we increment n, then we have and endless loop
(require rackunit)
(check-equal? (list) (count-down 0))
(check-equal? (list 3 2 1) (count-down 3))
