#lang racket
(require rackunit)
(check-false (empty? (list (+ 0 1) (+ 0 1 2) (+ 0 1 2 3))))
(check-true (empty? (list)))

;; ----

(check-equal?
  (cons 1
    (cons 2
      (cons 3
        (cons 4 empty)))) (list 1 2 3 4))

(define l (list 1 2 3 4))

(check-equal? (car l) 1)
(check-equal? (cdr l) (list 2 3 4))

(define (pair-swap p)
  (cons (cdr p) (car p)))

(check-false (equal? (list 2 3 4 1) (pair-swap l)))
(check-equal? (cons (list 2 3 4) 1) (pair-swap l))
(define (list-swap l)
  (define fst (car l))
  (define snd (car (cdr l)))
  (define rst (cdr (cdr l)))
  (cons
    snd
    (cons
      fst
      rst)))
(check-equal? (list 2 1 3 4) (list-swap l))

(define (list-swap-v2 l)
  (define fst (first l))
  (define snd (second l))
  (define rst (rest (rest l)))
  (cons
    snd
    (cons
      fst
      rst)))
(check-equal? (list 2 1 3 4) (list-swap-v2 l))
