#lang racket

(define (v1-pair< x y)
  (cond
    [(< (car x) (car y)) #t]
    [(> (car x) (car y)) #f]
    [(< (cdr x) (cdr y)) #t]
    [else #f]))

(define (pair< x y)
  (or
    (< (car x) (car y))
    (and (equal? (car x) (car y)) (< (cdr x) (cdr y)))))

(require rackunit)
(check-true (pair< (cons 1 3) (cons 2 3)))
(check-true (pair< (cons 1 2) (cons 1 3)))
(check-false (pair< (cons 1 3) (cons 1 3)))
(check-false (pair< (cons 1 3) (cons 1 0)))
(check-false (pair< (cons 2 3) (cons 1 0)))
(check-false (pair< (cons 2 1) (cons 1 3))) ; <-