#lang errortrace racket
(require "ast.rkt")

(define (r:eval-exp exp)
  (cond
    ; 1. When evaluating a number, just return that number
    [(r:number? exp) (r:number-value exp)]
    ; 2. When evaluating an arithmetic symbol,
    ;    return the respective arithmetic function
    [(r:variable? exp) (r:eval-builtin (r:variable-name exp))]
    ; 3. When evaluating a function call evaluate each expression and apply
    ;    the first expression to remaining ones
    [(r:apply? exp)
     ((r:eval-exp (r:apply-func exp)) ; (r:variable '+)
      (r:eval-exp (first (r:apply-args exp))) ; (r:number 10)
      (r:eval-exp (second (r:apply-args exp))))] ; (r:number 5)
    [else (error "Unknown expression:" exp)]))

(define (r:eval-builtin var)
  (cond [(equal? '+ var) +]
        [(equal? '- var) -]
        [(equal? '* var) *]
        [(equal? '/ var) /]
        [else #f]))

(check-equal? (r:eval-builtin '+) +)

(require rackunit)

(check-equal? 10 (r:number-value (r:number 10)))
(check-equal? (r:eval-exp (r:number 100)) 100)


(check-equal? (r:eval-exp (r:number 5)) 5)


(check-equal? (r:eval-exp (r:variable '+)) +)

(check-equal?
  (r:apply-args
    (r:apply
      ; func
      (r:variable '+)
      ; args
      (list
        (r:number 10)
        (r:number 5))))
  (list (r:number 10) (r:number 5)))

(check-equal?
  (r:eval-exp
    (r:apply
      (r:variable '+)
      (list
        (r:number 10)
        (r:number 5))))
  15)
(define a
    (r:apply
      (r:variable '+)
      (list
        (r:number 10)
        (r:number 5))))


(check-equal? (first (r:apply-args a)) (r:number 10))
;;;;;

(define (sum l)
  (apply + l))

(check-equal? (sum (list)) 0)

(check-equal? (sum (list 1 2 3 4)) 10)

;(and)

(define (sum:2 l)
  (cond [(empty? l) 0]
        [else (+ (first l) (sum:2 (rest l)))]))
(check-equal? (sum:2 (list 1 2 3)) 6)

(define (f x y z . rest-of-args)
  (cons (+ x y z) (sum rest-of-args)))

(check-equal? (f 1 2 3 4 5 6)
  (cons 6 15))

(define (my-apply f l)
  (define (apply-aux f l)
    (cond [(empty? l) f]
          [else (apply-aux (f (first l)) (rest l))]))
  (apply-aux f l))

(define (h a b)
  (+ a b))
(check-equal? 3 (my-apply h (list 1 2)))
