#lang errortrace racket
(require rackunit)
#|

     SYNTAX (AST)

|#
;; Values
(define (r:value? v) (or (r:number? v)))
(struct r:number (value) #:transparent)
;; Expressions
(define (r:expression? e)
  (or (r:value? e)
      (r:variable? e)
      (r:apply? e)))
(struct r:variable (name) #:transparent)
(struct r:apply (func args) #:transparent)
#|

     SEMANTICS (EVALUATION)

|#
#|
(define (safe-/ x y)
  (cond [(= y 0) #f]
        [else (/ x y)]))

(define (r:eval-builtin sym)
  (cond [(equal? sym '+) +]
        [(equal? sym '*) *]
        [(equal? sym '-) -]
        [(equal? sym '/) safe-/]
        [else #f]))
|#
#|
(define/contract (r:eval-exp exp)
  (-> r:expression? (or/c (-> real? real? real?) real? #f))
  (cond
    [(r:number? exp) (r:number-value exp)]
    [(r:variable? exp) (r:eval-builtin (r:variable-name exp))]
    [(r:apply? exp)
     ((r:eval-exp (r:apply-func exp))
      (r:eval-exp (first (r:apply-args exp)))
      (r:eval-exp (second (r:apply-args exp))))]
    [else (error "Unknown expression:" exp)]))
|#
; Slide 4
;(r:eval-exp (r:variable '+))


; Slide 5

;(r:eval-exp (r:apply (r:variable '/) (list (r:number 1) (r:number 0))))


; Slide 8
#|
(check-false (safe-/ 0 0))
(check-false (safe-/ 1 0))
(check-equal? (safe-/ 4 2) 2)
|#

#|


(define (r:eval-builtin sym)
  (cond [(equal? sym '+) +]
        [(equal? sym '*) *]
        [(equal? sym '-) -]
        [(equal? sym '/) safe-/]
        [else #f]))
|#
; Slide 10
#|
(define (r:eval-exp exp)
  (-> r:expression? (or/c (-> real? real? real?) real? #f))
  (cond
    [(r:number? exp) (r:number-value exp)]
    [(r:variable? exp) (r:eval-builtin (r:variable-name exp))]
    [(r:apply? exp)
     (define arg1 (r:eval-exp (first (r:apply-args exp))))
     (cond
       [(false? arg1) arg1]
       [else
         (define arg2 (r:eval-exp (second (r:apply-args exp))))
         (cond
           [(false? arg2) arg2]
           [else ((r:eval-exp (r:apply-func exp)) arg1 arg2)])])]
    [else (error "Unknown expression:" exp)]))
|#

; Slide 9
#|
(r:eval-exp
  (r:apply
    (r:variable '+)
    (list
      (r:apply (r:variable '/) (list (r:number 1) (r:number 0)))
      (r:number 10))))
|#


; Slide 11

(define (handle-err res kont)
  (cond
    [(false? res) res]
    [else (kont res)]))
#|
(define (r:eval-exp exp)
  (cond
    [(r:number? exp) (r:number-value exp)]
    [(r:variable? exp) (r:eval-builtin (r:variable-name exp))]
    [(r:apply? exp)
     (handle-err (r:eval-exp (first (r:apply-args exp)))
       (lambda (arg1)
         (handle-err (r:eval-exp (second (r:apply-args exp)))
           (lambda (arg2)
             ((r:eval-exp (r:apply-func exp)) arg1 arg2)))))]
    [else (error "Unknown expression:" exp)]))
(r:eval-exp
  (r:apply
    (r:variable '+) ; +
    (list
      (r:apply (r:variable '/) (list (r:number 1) (r:number 0))) ; #f
      (r:number 10)))) ; 10
(r:eval-exp (r:apply (r:variable 'modulo) (list (r:number 1) (r:number 0))))
|#




; Slide 13
#|
(define (r:eval-exp exp)
  (cond
    [(r:number? exp) (r:number-value exp)]
    [(r:variable? exp) (r:eval-builtin (r:variable-name exp))]
    [(r:apply? exp)
     (handle-err (r:eval-exp (r:apply-func exp))
        (lambda (func)
          (handle-err (r:eval-exp (first (r:apply-args exp)))
            (lambda (arg1)
              (handle-err (r:eval-exp (second (r:apply-args exp)))
                (lambda (arg2)
                  (func arg1 arg2)))))))]
    [else (error "Unknown expression:" exp)]))
(r:eval-exp (r:apply (r:variable 'modulo) (list (r:number 1) (r:number 0))))
|#
; Slide 16

(define-syntax do
  (syntax-rules (<-)
    ; Only one monadic-op, return it
    [(_ mexp) mexp]
    ; A binding operation
    [(_ var <- mexp rest ...) (handle-err mexp (lambda (var) (do rest ...)))]
    ; No binding operator, just ignore the return value
    [(_ mexp rest ...)        (handle-err mexp (lambda (_) (do rest ...)))]))

; Slide 17
#|
(define (r:eval-exp exp)
  (cond
    [(r:number? exp) (r:number-value exp)]
    [(r:variable? exp) (r:eval-builtin (r:variable-name exp))]
    [(r:apply? exp)
     (do
      func <- (r:eval-exp (r:apply-func exp))
      arg1 <- (r:eval-exp (first (r:apply-args exp)))
      arg2 <- (r:eval-exp (second (r:apply-args exp)))
      (func arg1 arg2))]
    [else (error "Unknown expression:" exp)]))
(r:eval-exp (r:apply (r:variable 'modulo) (list (r:number 1) (r:number 0))))
|#
#|
(struct eff-op (func))

(define (eff-bind o1 o2)
  (-> eff-op? (-> any/c eff-op?) any/c)
  (eff-op
    (lambda (h1)
      (define h2+r (eff-run o1 h1))
      (define r (eff-result h2+r))
      (define h2 (eff-state h2+r))
      (eff-run (o2 r) h2))))

(define/contract (push n)
  (-> real? eff-op?)
  (eff-op
    (lambda (stack)
      (eff (cons n stack) (void)))))

(define (pop)
  (-> real? eff-op?)
  (eff-op
    (lambda (stack)
      (eff (rest stack) (first stack)))))

(define (bind op1 op2)
  (cond
    [(eff-op? op1) (eff-bind o1 o2)]
    [?? (handle-err o1 o2)]
    [(list? op1) (list-bind o1 o2)]))
|#
(struct maybe ())
(struct some (data) #:super struct:maybe)
(struct none () #:super struct:maybe)

(check-true (maybe? (some 1)))
(check-true (some? (some 1)))
(check-false (some? (none)))
(check-false (some? (maybe)))

(define (safe-/ x y)
  (cond [(= y 0) (none)]
        [else (some (/ x y))]))

(define (r:eval-builtin sym)
  (cond [(equal? sym '+) (some +)]
        [(equal? sym '*) (some *)]
        [(equal? sym '-) (some -)]
        [(equal? sym '/) (some safe-/)]
        [else (none)]))


(define (maybe-bind res kont)
  (cond
    [(none? res) res]
    [else (kont (some-data res))]))
(define (maybe-pure x) (some x))

(define (r:eval-exp exp)
  (cond
    [(r:number? exp) (r:number-value exp)]
    [(r:variable? exp) (r:eval-builtin (r:variable-name exp))]
    [(r:apply? exp)
     (maybe-bind (r:eval-exp (r:apply-func exp))
        (lambda (func)
          (maybe-bind (r:eval-exp (first (r:apply-args exp)))
            (lambda (arg1)
              (maybe-bind (r:eval-exp (second (r:apply-args exp)))
                (lambda (arg2)
                  (func arg1 arg2)))))))]
    [else (error "Unknown expression:" exp)]))
(r:eval-exp (r:apply (r:variable 'modulo) (list (r:number 1) (r:number 0))))


#|
|#
#|
; Slide 20
(define (join elems)
  (foldr append empty elems))
(check-equal? (join (list (list 1 2)))
  (list 1 2))
(check-equal? (join (list (list 1) (list 2)))
  (list 1 2))
(check-equal? (join (list (list 1 2) (list 3)))
  (list 1 2 3))

; Slide 21

(define (list-pure x) (list x))
(define (list-bind op1 op2)
  (join (map op2 op1)))

(define-syntax do
  (syntax-rules (<-)
    ; Only one monadic-op, return it
    [(_ mexp) mexp]
    ; A binding operation
    [(_ var <- mexp rest ...) (list-bind mexp (lambda (var) (do rest ...)))]
    ; No binding operator, just ignore the return value
    [(_ mexp rest ...)        (list-bind mexp (lambda (_) (do rest ...)))]))
(define lst
  (do
    x <- (list 1 2)
    y <- (list 3 4)
    (list-pure (cons x y))))
|#